function Menu()
{
	this.selection = 0;
	this.page = 0;
	this.heading = "";
	this.open = false;
	this.items = new Array();
	this.drawAny = true;
	this.doWhile = function() {}
}

Menu.prototype.addItem = function(name)
{
	var item = new Object();
	item.name = name;
	item.enabled = true;
	this.items[this.items.length] = item;
}

Menu.prototype.execute = function(x, y, w, h)
{
	this.draw(x, y, w, h * 12 + 8);
	if (KeyPressed())
	{
		if (IsKeyPressed(KEY_DOWN))
		{
			if (this.selection < h - 1)
			{
				this.selection ++;
			}
			PressKey();
		}
		if (IsKeyPressed(KEY_UP))
		{
			if (this.selection > 0)
			{
				this.selection --;
			}
			PressKey();
		}
		if (IsKeyPressed(KEY_A))
		{
			if (this.items[this.selection] != undefined)
			{
				if (this.items[this.selection].enabled)
				{
					PressKey();
					return this.selection;
				}
				else
					PressKey("error");
			}
			else
				PressKey("error");
		}
	}
}

Menu.prototype.draw = function(x, y, w, h)
{
	this.doWhile(this.selection);
	if (this.drawAny)
	{
		window.drawWindow(x, y, w, h);
		font.littleText(x + w + 4, y - 3, (this.page + 1), "right");
		for (var i = 0; i < this.items.length; i ++)
		{
			font.drawText(x + 4, y +4 + i * 12, this.items[i].name);
		}
		DrawCursor(x - 1, y + 4 + (this.selection - this.page * h) * 12, w + 2);
	}
}

Menu.prototype.importArray = function(array, special)
{
	this.items = new Array();
	for (var i = 0; i < array.length; i ++)
	{
		this.items[i] = array[i];
		this.items[i].enabled = true;
	}
	if (this.items.length == 0)
	{
		this.addItem("");
		this.items[0].enabled = false;
	}
}